
Some constructors of the `ArgumentException`, `ArgumentNullException`, `ArgumentOutOfRangeException` and<br>`DuplicateWaitObjectException` classes must be fed with a valid parameter name. This rule raises an issue in two cases:

- When this parameter name doesn't match any existing ones.
- When a call is made to the default (parameterless) constructor


## Noncompliant Code Example


    public void Foo(Bar a, int[] b)
    {
      throw new ArgumentException(); // Noncompliant
      throw new ArgumentException("My error message", "c"); // Noncompliant
      throw new ArgumentException("My error message", "c", innerException); // Noncompliant
      throw new ArgumentNullException("c"); // Noncompliant
      throw new ArgumentNullException("My error message", "c"); // Noncompliant
      throw new ArgumentOutOfRangeException("c");
      throw new ArgumentOutOfRangeException("c", "My error message"); // Noncompliant
      throw new ArgumentOutOfRangeException("c", b, "My error message"); // Noncompliant
    }


## Compliant Solution


    public void Foo(Bar a, Bar b)
    {
      throw new ArgumentException("My error message", "a");
      throw new ArgumentException("My error message", "b", innerException);
      throw new ArgumentNullException("a");
      throw new ArgumentNullException(nameOf(a));
      throw new ArgumentNullException("My error message", "a");
      throw new ArgumentOutOfRangeException("b");
      throw new ArgumentOutOfRangeException("b", "My error message");
      throw new ArgumentOutOfRangeException("b", b, "My error message");
    }


## Exceptions

The rule won't raise an issue if the parameter name is not a constant value (inline declaration, nameof() or const variable).
