
When a base type explicitly implements a public interface method, that method is only accessible in derived types through a reference to the<br>current instance (namely `this`). If the derived type explicitly overrides that interface method, the base implementation becomes<br>inaccessible.

This rule raises an issue when an unsealed, externally visible type provides an explicit method implementation of a `public interface`<br>and does not provide an alternate, externally visible method with the same name.

## Noncompliant Code Example


    public interface IMyInterface
    {
        void MyMethod();
    }
    
    public class Foo : IMyInterface
    {
        void IMyInterface.MyMethod() // Noncompliant
        {
            MyMethod();
        }
    
        void MyMethod()
        {
            // Do something ...
        }
    }
    
    public class Bar : Foo, IMyInterface
    {
        public void MyMethod()
        {
            // Can't access base.MyMethod()
            // ((IMyInterface)this).MyMethod() would be a recursive call
        }
    }


## Compliant Solution


    public interface IMyInterface
    {
        void MyMethod();
    }
    
    public class Foo : IMyInterface
    {
        void IMyInterface.MyMethod()
        {
            MyMethod();
        }
    
        protected void MyMethod() // or public
        {
            // Do something ...
        }
    }
    
    public class Bar : Foo, IMyInterface
    {
        public void MyMethod()
        {
            // Do something
            base.MyMethod();
        }
    }


## Exceptions

This rule does not report a violation for an explicit implementation of `IDisposable.Dispose` when an externally visible<br>`Close()` or `System.IDisposable.Dispose(Boolean)` method is provided.
