
There are valid cases for passing a variable multiple times into the same method call, but usually doing so is a mistake, and something else was<br>intended for one of the arguments.

## Noncompliant Code Example


    if (Compare(point.X, point.X) != 0) // Noncompliant
    {
    &nbsp;&nbsp;//...
    }
    
    if (DoSomething(GetNextValue(), GetNextValue()))  // Noncompliant
    {
    &nbsp;&nbsp;// ...
    }


## Compliant Solution


    if (Compare(point.X, point.Y) != 0)
    {
    &nbsp;&nbsp;//...
    }
    
    var v1 = GetNextValue();
    var v2 = GetNextValue();
    if (DoSomething(v1, v2))
    {
    &nbsp;&nbsp;// ...
    }


## Deprecated

This rule is deprecated, and will eventually be removed.
