
The `PartCreationPolicyAttribute` attribute, which is part of the Managed Extensibility Framework (MEF), is used to specify how the<br>exported object will be created. Therefore it doesn't make sense not to export this a class with this attribute using the `ExportAttribute`<br>attribute.

This rule raises an issue when a class is marked as shared with a `PartCreationPolicyAttribute` but lacks a<br>`ExportAttribute`.

## Noncompliant Code Example


    [PartCreationPolicy(CreationPolicy.Any)] // Noncompliant
    public class FooBar : IFooBar
    {
    }


## Compliant Solution


    [Export(typeof(IFooBar))]
    [PartCreationPolicy(CreationPolicy.Any)]
    public class FooBar : IFooBar
    {
    }

