B608: Test for SQL injection
----------------------------

An SQL injection attack consists of insertion or "injection" of a SQL
query via the input data given to an application. It is a very common
attack vector. This plugin test looks for strings that resemble SQL
statements that are involved in some form of string building operation.
For example:

Unless care is taken to sanitize and control the input data when
building such SQL statement strings, an injection attack becomes
possible. If strings of this nature are discovered, a LOW confidence
issue is reported. In order to boost result confidence, this plugin test
will also check to see if the discovered string is in use with standard
Python DBAPI calls execute or executemany. If so, a MEDIUM issue is
reported. For example:
