## COPY --from cannot reference its own FROM alias

### Problematic code:

```dockerfile
FROM debian:jesse as build

COPY --from=build some stuff ./
```

### Correct code:

```dockerfile
FROM debian:jesse as build

RUN stuff

FROM debian:jesse

COPY --from=build some stuff ./
```
### Rationale:

Trying to copy from the same image the instruction is running in results in an error.