## Use only an allowed registry in the FROM image

### Problematic code:

```dockerfile
FROM randomguy/python:3.6
...
```

### Correct code:

```dockerfile
FROM my-registry.com/python:3.6
...
```

### Rationale:

Using the `FROM` instruction is a huge exercise in trust, you have to trust that a particular version or an image is safe for you to use, and that it will never be retagged maliciously. In order to prevent that, some companies copy trusted images into their own repositories, and reference them directly.

For example, this would be an untrusted image:

```dockerfile
FROM randomguy/fancy:10
...
```

But after an audit, the company decides to copy the image into their own repository, as it was deemed safe:

```dockerfile
FROM my-registry.com/fancy:10
...
```

The idea is that hadolint can warn whenever an untrusted repo is used, you can use the `--trusted-registry` flag for that

```bash
hadolint --trusted-registry my-registry.com Dockerfile
```