//#Patterns: Custom_Scala_HardCodedKey
package docs.tests

import java.security.spec.{PKCS8EncodedKeySpec, X509EncodedKeySpec}
import javax.crypto.spec.{DESKeySpec, DESedeKeySpec, SecretKeySpec}
import javax.security.auth.kerberos.KerberosTicket;

class HardCodedKey {

  private val hardcodedKey = Array[Byte](192.toByte, 168.toByte, 1, 2)
  private val hardcodedCryptoKey = "secret".getBytes
 
  //#Warn: Custom_Scala_HardCodedKey
  new DESKeySpec(Array[Byte](192.toByte, 168.toByte, 1, 2))
  //#Warn: Custom_Scala_HardCodedKey
  new DESKeySpec(Array[Byte](1, 1, 1, 2))
  //#Warn: Custom_Scala_HardCodedKey
  new DESKeySpec(Array(2, 3, 4, 5).map(_.toByte))

  //#Warn: Custom_Scala_HardCodedKey
  new DESedeKeySpec(Array[Byte](192.toByte, 168.toByte, 1, 2))
  //#Warn: Custom_Scala_HardCodedKey
  new DESedeKeySpec(Array[Byte](1, 1, 1, 2))
  //#Warn: Custom_Scala_HardCodedKey
  new DESedeKeySpec(Array(2, 3, 4, 5).map(_.toByte))

  //#Warn: Custom_Scala_HardCodedKey
  new SecretKeySpec(Array(2, 3, 4, 5).map(_.toByte), "alg");
  //#Warn: Custom_Scala_HardCodedKey
  new X509EncodedKeySpec(Array[Byte](1, 1, 1, 2));
  //#Warn: Custom_Scala_HardCodedKey
  new PKCS8EncodedKeySpec(Array[Byte](1, 1, 1, 2));
  //#Warn: Custom_Scala_HardCodedKey
  new KerberosTicket(null, null, null, Array[Byte](1, 1, 1, 2), 0, null, null, null, null, null, null);
  //#Warn: Custom_Scala_HardCodedKey
  new DSAPublicKeyImpl(Array[Byte](1, 1, 1, 2));
  //#Warn: Custom_Scala_HardCodedKey
  new DSAPublicKeyImpl("secret".getBytes)
  //#Warn: Custom_Scala_HardCodedKey
  new DSAPublicKeyImpl("secret".getBytes())

  def arguments(key: Array[Byte], keyInt: Array[Int], strKey: String) = {  
    new DESKeySpec(key)
    new DESedeKeySpec(key)
    new SecretKeySpec(keyInt.map(_.toByte), "alg");
    new X509EncodedKeySpec(key);
    new PKCS8EncodedKeySpec(key)
    new KerberosTicket(null, null, null, key, 0, null, null, null, null, null, null);
    new DSAPublicKeyImpl(key)
    new DSAPublicKeyImpl(strKey.getBytes)
  }

  def lookupClassLevel() = {
    //#Warn: Custom_Scala_HardCodedKey
    new DSAPublicKeyImpl(hardcodedKey)
  }

  def anonymousFunctionParam1() = {
    Option("").map(hardcodedKey => new DSAPublicKeyImpl(hardcodedKey))
    Option("").map{ case hardcodedKey => new DSAPublicKeyImpl(hardcodedKey)}
    Option(("","")).map{ case bar@(hardcodedKey,t2) => new DSAPublicKeyImpl(hardcodedKey)}
  }

  def anonymousFunctionParam2() = {
     //#Warn: Custom_Scala_HardCodedKey
    Option("").map(password => new DSAPublicKeyImpl(hardcodedCryptoKey))
  }

  def anonymousFunctionParam3() = {
     //#Warn: Custom_Scala_HardCodedKey
     Option("").map{ case bar => new DSAPublicKeyImpl(hardcodedCryptoKey)}
  }


  val newCryptoKey = "a".getBytes
  //#Warn: Custom_Scala_HardCodedKey
  new DSAPublicKeyImpl(newCryptoKey)


}
