## `\t` is just literal `t` here. For tab, use `"$(printf '\t')"` instead.

### Problematic code:

```sh
# Want tab
var=foo\tbar
```

or

```sh
# Want linefeed
var=foo\nbar
```

### Correct code:

```sh
var="foo$(printf '\t')bar"  # As suggested in warning
var="$(printf 'foo\tbar')"  # Equivalent alternative
```

or
```sh
# Literal, quoted linefeed
line="foo
bar"
```
### Rationale:

ShellCheck has found a `\t`, `\n` or `\r` in a context where they just become regular letter `t`, `n` or `r`. Most likely, it was intended as a tab, linefeed or carriage return.

To generate such characters (plus other less common ones including `\a`, `\f` and octal escapes) , use `printf` as in the example. The exception is for linefeeds that would be stripped by command substitution; in these cases, use a literal quoted linefeed instead.

Other characters like `\z` generate a [[SC1001]] info message, as the intent is less certain.

### Exceptions:

None.

### Related resources:

* Help by adding links to BashFAQ, StackOverflow, man pages, POSIX, etc!
[Source](https://github.com/koalaman/shellcheck/wiki/SC1012)

