## Trying to declare parameters? Don't. Use () and refer to params as $1, $2..

### Problematic code:

```sh
foo(input) {
  echo "$input"
}
foo("hello world");
```

### Correct code:

```sh
foo() {
  echo "$1"
}
foo "hello world"
```

### Rationale:

Shell script functions behave just like scripts and other commands:

  - They always take a 0 to N parameters, referred to with `$1`, `$2` etc. They can not declare parameters by name.
  - They are executed using `name arg1 arg2`, and not with parentheses as C-like languages.

### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1065)

