## This is a unicode dash. Delete and retype as ASCII minus.

### Problematic code:

```sh
[[ 3 –gt 2 ]] # Uses unicode en-dash character
```

### Correct code:

```sh
[[ 3 -gt 2 ]] # Uses regular ASCII hyphen-minus character
```
### Rationale:

A character that looks similar to `-` has made its way into your code. This is usually due to copy-pasting from blogs and other websites that formatted code as text, replacing the ASCII hyphen-minus with a Unicode dash character.

To fix it, simply delete and retype it.

For a large script, you can use your editor's Search&Replace by copy-pasting the bad dash.

### Exceptions:

None. If you want a literal Unicode dash character, just quote it.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1100)

