## ShellCheck directives are only valid in front of complete commands like 'case' statements, not individual case branches.

### Problematic code:

```sh
case $? in
  0) echo "Success" ;;
  # shellcheck disable=2154
  *) echo "$cmd $flag returned failure" ;;
esac

```

### Correct code:
```sh
# Applies to everything in the `case` statement
# shellcheck disable=2154
case $? in
  0) echo "Success" ;;
  *) echo "$cmd $flag returned failure" ;;
esac
```

or 

```sh
case $? in
  0) echo "Success" ;;
  *)
     # Applies to a single command within the `case`
     # shellcheck disable=2154
     echo "$cmd $flag returned failure"
     ;;
esac
```


### Rationale:

You appear to have put a directive before a branch in a case statement.

ShellCheck directives can not be scoped to individual branches of `case` statements, only to the entire `case`, or to individual commands within it. Please move the directive as appropriate.

(It is possible to apply directives to all commands within a `{ ..: }` command group, if you truly wish to apply a directive to multiple commands but not the full `case` statement.)
    
### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1124)

