## Place shellcheck directives before commands, not after.

### Problematic code:

```sh
var=1 # shellcheck disable=SC2034
```

### Correct code:

```sh
# shellcheck disable=SC2034
var=1 
```
### Rationale:

ShellCheck expects directives to come before the relevant command. They are not allowed after.

### Exceptions:

If this is not a directive and just a comment mentioning ShellCheck, please rewrite or capitalize:

    var=1 # ShellCheck encourages lowercase variable names
[Source](https://github.com/koalaman/shellcheck/wiki/SC1126)

