# Make sure all escape sequences are enclosed in `\[..\]` to prevent line wrapping issues

### Problematic code:

```sh
PS1='\e[36m\$ \e(B\e[m'
```

### Correct code:

```sh
PS1='\[\e[36m\]\$ \[\e(B\e[m\]'
```

### Rationale:

Bash is unable to determine exactly which parts of your prompt are text and which are terminal codes. You have to help it by wrapping invisible control codes in `\[..\]` (and ensuring that visible characters are not wrapped in `\[..\]`).

Note: ShellCheck offers this as a helpful hint and not a robust check. Don't rely on ShellCheck to verify that your prompt is correct.

### Exceptions

None.

### Related resources:

* [BashFaq: I have a fancy prompt with colors, and now bash doesn't seem to know how wide my terminal is. Lines wrap around incorrectly.](https://mywiki.wooledge.org/BashFAQ/053)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2025)

