## Unknown unaryoperator.

### Problematic code:

```sh
[ -E 42 ]
```

### Correct code:

```sh
[ -e 42 ]
```

### Rationale:

You are using an unknown unary operator in a `test` expression. Perhaps it's a typo?

In bash, you can use `help test` to see a list of supported operators:

      -a FILE        True if file exists.
      -b FILE        True if file is block special.
      -c FILE        True if file is character special.
      -d FILE        True if file is a directory.
      -e FILE        True if file exists.
      -f FILE        True if file exists and is a regular file.
      -g FILE        True if file is set-group-id.
      -h FILE        True if file is a symbolic link.
      -L FILE        True if file is a symbolic link.
      -k FILE        True if file has its `sticky' bit set.
      -p FILE        True if file is a named pipe.
      -r FILE        True if file is readable by you.
      -s FILE        True if file exists and is not empty.
      -S FILE        True if file is a socket.
      -t FD          True if FD is opened on a terminal.
      -u FILE        True if the file is set-user-id.
      -w FILE        True if the file is writable by you.
      -x FILE        True if the file is executable by you.
      -O FILE        True if the file is effectively owned by you.
      -G FILE        True if the file is effectively owned by your group.
      -N FILE        True if the file has been modified since it was last read.

### Exceptions:

None. If you've tested and verified that the operator works but the latest version of ShellCheck says it's unknown, please [submit a bug report](https://github.com/koalaman/shellcheck/issues).

### Related resources:

* [The classic test command](http://wiki.bash-hackers.org/commands/classictest) on the Bash Hackers wiki.
* [The conditional expression](http://wiki.bash-hackers.org/syntax/ccmd/conditional_expression) on the Bash Hackers wiki.
* [Tests and conditionals](https://mywiki.wooledge.org/BashGuide/TestsAndConditionals) on the Wooledge BashGuide.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2058)

