## Quote the parameter to -name so the shell won't interpret it.

### Problematic code:

```sh
find . -name *.txt
```

### Correct code:

```sh
find . -name '*.txt'
```
### Rationale:

Several find options take patterns to match against, including `-ilname`, `-iname`, `-ipath`, `-iregex`, `-iwholename`, `-lname`, `-name`, `-path`, `-regex` and `-wholename`.

These compete with the shell's pattern expansion, and must therefore be quoted so that they are passed literally to `find`.

The example command may end up executing as `find . -name README.txt` after the shell has replaced the `*.txt` with a matching file `README.txt` from the current directory. 

This may happen today or suddenly in the future.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2061)

