## Can't use `=~` in `[ ]`. Use `[[..]]` instead.

### Problematic code:

```sh
[ "$input" =~ DOC[0-9]*\.txt ] && echo "match"
```

### Correct code:

```sh
[[ "$input" =~ DOC[0-9]*\.txt ]] && echo "match"
```
### Rationale:

`=~` only works in `[[ .. ]]` tests. It does not work with `test` or `[` in any shell.

If you're targeting POSIX `sh`, rewrite in terms of `case` or `grep` instead.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC2074)

