## You need spaces around the comparison operator.

### Problematic code:

```sh
[[ 0=1 ]]
```

### Correct code:

```sh
[[ 0 = 1 ]]
```

### Rationale:

`[[ 0 = 1 ]]` means "check if 0 and 1 are equal".

`[[ str ]]` is short form for `[[ -n str ]]`, and means "check if `str` is non-empty". It doesn't matter if `str` happens to contain `0=1`.

Always use spaces around the comparison operator in `[..]` and `[[..]]`, otherwise it won't be recognized as an operator.

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2077)

