## Remove "exec " if script should continue after this command.

### Problematic code:

```sh
echo "Starting compilation"
exec ./compile
echo "Starting deployment"
exec ./deploy
```

### Correct code:

```sh
echo "Starting compilation"
./compile
echo "Starting deployment"
./deploy
```

### Rationale:

The script contains an `exec` command followed by other commands in the same block. This is likely an error because the script will not resume after an `exec` command.

Instead, "exec" refers to the Unix process model's idea of execution (see [`execve(2)`](http://man7.org/linux/man-pages/man2/execve.2.html)), in which the current process stops its current program and replaces it with a new one. This is mainly used in wrapper scripts.

To execute another script or program and then continue, simply drop the `exec` as in the example.

### Exceptions:

If the code after the `exec` is only there to handle a failure in executing the command you can ignore this warning. For this reason, ShellCheck suppresses the warning if `exec` is only followed by `echo`/`exit` commands.

### Related resources:

* StackOverflow: [My shell script stops after exec](https://stackoverflow.com/questions/3877657/my-shell-script-stops-after-exec)
[Source](https://github.com/koalaman/shellcheck/wiki/SC2093)

