## Use "${var:?}" to ensure this never expands to /* .

### Problematic code:

```sh
rm -rf "$STEAMROOT/"*
```

### Correct code:

```sh
rm -rf "${STEAMROOT:?}/"*
```

### Rationale:

If `STEAMROOT` is empty, this will [end up deleting everything](https://github.com/ValveSoftware/steam-for-linux/issues/3671) in the system's root directory.

Using `:?` will cause the command to fail if the variable is null or unset. Similarly, you can use `:-` to set a default value if applicable.

In the case command substitution, assign to a variable first and then use `:?`. This is relevant even if the command seems simple and obviously correct, since forks and execs can fail due to external system limits and conditions, resulting in a blank substitution.

For more details about `:?` see the "Parameter Expansion" section of the Bash man page.
### Exceptions:

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC2115)

