## Quote this invalid brace expansion since it should be passed literally to eval

### Problematic code:

```sh
eval echo {1..$n}
```

### Correct code:

```sh
eval "echo {1..$n}"
```
### Rationale:

Using `eval somecommand {1..$n}` depends both on bash silently failing to interpret the brace expansion, and on it passing failing brace expansions literally. 

Rather than depending on these questionable features (which already behave differently in other shells), use the explicit, predictable way of passing values literally: quoting.

### Exceptions:

None. 
[Source](https://github.com/koalaman/shellcheck/wiki/SC2175)

