
Shared naming conventions allow teams to collaborate efficiently. This rule checks whether or not type names are using PascalCase. To reduce noise,<br>two consecutive upper case characters are allowed unless they form the whole type name. So, `MyXClass` is compliant, but `XC` on<br>its own is not.

## Noncompliant Code Example


    class my_class {...}
    class SOMEName42 {...}


## Compliant Solution


    class MyClass {...}
    class SomeName42 {...}


## Exceptions

- The rule ignores types that are marked with `ComImportAttribute` or `InterfaceTypeAttribute`.
- The rule allows for two-letter acronyms in which both letters are capitalized, as shown in the following identifier: `IOStream`
- The rule allows having `'_'` characters in class names inside test projects.



    class Some_Name___42 {...} // valid in test
    class Some_name___42 {...} // still not valid
    class Some_Name_XC {...} // invalid because of XC, should be Some_Name_Xc


## See

- [Microsoft Capitalization<br>  Conventions](https://docs.microsoft.com/en-us/dotnet/standard/design-guidelines/capitalization-conventions)

