
If Finalize or an override of Finalize throws an exception, and the runtime is not hosted by an application that overrides the default policy, the<br>runtime terminates the process immediately without graceful cleanup (finally blocks and finalizers are not executed). This behavior ensures process<br>integrity if the finalizer cannot free or destroy resources.

The rule reports on throw statements used in finalizers.

## Noncompliant Code Example


    class MyClass
    {
        ~MyClass()
        {
            throw new NotImplementedException(); // Noncompliant
        }
    }


## Compliant Solution


    class MyClass
    {
        ~MyClass()
        {
            // no throw
        }
    }

