
Using `.Count()` to test for emptiness works, but using `.Any()` makes the intent clearer, and the code more readable.<br>However, there are some cases where special attention should be paid:

- if the collection is an `EntityFramework` or other ORM query, calling `.Count()` will cause executing a potentially massive<br>SQL query and could put a large overhead on the application database. Calling `.Any()` will also connect to the database, but will generate<br>much more efficient SQL.

- if the collection is part of a LINQ query that contains `.Select()` statements that create objects, a large amount of memory could be<br>unnecessarily allocated. Calling `.Any()` will be much more efficient because it will execute fewer iterations of the enumerable.

## Noncompliant Code Example


    private static bool HasContent(IEnumerable&lt;string&gt; strings)
    {
      return strings.Count() &gt; 0;  // Noncompliant
    }
    
    private static bool HasContent2(IEnumerable&lt;string&gt; strings)
    {
      return strings.Count() &gt;= 1;  // Noncompliant
    }
    
    private static bool IsEmpty(IEnumerable&lt;string&gt; strings)
    {
      return strings.Count() == 0;  // Noncompliant
    }


## Compliant Solution


    private static bool HasContent(IEnumerable&lt;string&gt; strings)
    {
      return strings.Any();
    }
    
    private static bool IsEmpty(IEnumerable&lt;string&gt; strings)
    {
      return !strings.Any();
    }

