
The difference between `private` and `protected` visibility is that child classes can see and use `protected`<br>members, but they cannot see `private` ones. Since a `sealed` class cannot have children, marking its members<br>`protected` is confusingly pointless.

## Noncompliant Code Example


    public sealed class MySealedClass
    {
        protected string name = "Fred";  // Noncompliant
        protected void SetName(string name) // Noncompliant
        {
            // ...
        }
    }


## Compliant Solution


    public sealed class MySealedClass
    {
        private string name = "Fred";
        public void SetName(string name)
        {
            // ...
        }
    }

