
`Dispose` as a method name should be used exclusively to implement `IDisposable.Dispose` to prevent any confusion.

It may be tempting to create a `Dispose` method for other purposes, but doing so will result in confusion and likely lead to problems in<br>production.

## Noncompliant Code Example


    public class GarbageDisposal
    {
      private int Dispose()  // Noncompliant
      {
        // ...
      }
    }


## Compliant Solution


    public class GarbageDisposal : IDisposable
    {
      public void Dispose()
      {
        // ...
      }
    }


or


    public class GarbageDisposal
    {
      private int Grind()
      {
        // ...
      }
    }


## Exceptions

Methods named `Dispose` and invoked from the `IDisposable.Dispose` implementation are not reported.


    public class GarbageDisposal  :  IDisposable
    {
      protected virtual void Dispose(bool disposing)
      {
        //...
      }
      public void Dispose()
      {
        Dispose(true);
        GC.SuppressFinalize(this);
      }
    }

