
Assigning a value to a `static` field in a constructor could cause unreliable behavior at runtime since it will change the value for all<br>instances of the class.

Instead remove the field's `static` modifier, or initialize it statically.

## Noncompliant Code Example


    public class Person
    {
      private static DateTime dateOfBirth;
      private static int expectedFingers;
    
      public Person(DateTime birthday)
      {
        dateOfBirth = birthday;  // Noncompliant; now everyone has this birthday
        expectedFingers = 10;  // Noncompliant
      }
    }


## Compliant Solution


    public class Person
    {
      private DateTime dateOfBirth;
      private static int expectedFingers = 10;
    
      public Person(DateTime birthday)
      {
        this.dateOfBirth = birthday;
      }
    }

