
After an `await`ed `Task` has executed, you can continue execution in the original, calling thread or any arbitrary thread.<br>Unless the rest of the code needs the context from which the `Task` was spawned, `Task.ConfigureAwait(false)` should be used to<br>keep execution in the `Task` thread to avoid the need for context switching and the possibility of deadlocks.

This rule raises an issue when code in a class library `await`s a `Task` and continues execution in the original calling<br>thread.

## Noncompliant Code Example


    var response = await httpClient.GetAsync(url);  // Noncompliant


## Compliant Solution


    var response = await httpClient.GetAsync(url).ConfigureAwait(false);

