
In the interests of keeping code clean, the simplest possible conditional syntax should be used. That means

- using the `??` operator for an assign-if-not-null operator,
- using the ternary operator `?:` for assignment to a single variable, and
- removing the `??` when the left operand is known to be `null`, or known to be definitely not `null`.


## Noncompliant Code Example


    object a = null, b = null, x;
    
    if (a != null) // Noncompliant; needlessly verbose
    {
      x = a;
    }
    else
    {
      x = b;
    }
    
    x = a != null ? a : b; // Noncompliant; better but could still be simplified
    
    x = (a == null) ? new object() : a; // Noncompliant
    
    if (condition) // Noncompliant
    {
      x = a;
    }
    else
    {
      x = b;
    }
    
    var y = null ?? new object(); // Noncompliant


## Compliant Solution


    object x;
    
    x = a ?? b;
    x = a ?? b;
    x = a ?? new object();
    x = condition ? a : b;
    var y = new object();

