
A class with only `private` constructors can't be instantiated, thus, it seems to be pointless code.

## Noncompliant Code Example


    public class MyClass // Noncompliant
    {
      private MyClass() { ... }
    }


## Compliant Solution


    public class MyClass
    {
      public MyClass() { ... }
    }


## Exceptions

Classes that themselves access their private constructors (singletons or smart enums) are ignored. Classes with only `static` members<br>are also ignored because they are covered by Rule S1118.
