
Adding `params` to a method override has no effect. The compiler accepts it, but the callers won't be able to benefit from the added<br>modifier.

## Noncompliant Code Example


    class Base
    {
      public virtual void Method(int[] numbers)
      {
        ...
      }
    }
    class Derived : Base
    {
      public override void Method(params int[] numbers) // Noncompliant, method can't be called with params syntax.
      {
        ...
      }
    }


## Compliant Solution


    class Base
    {
      public virtual void Method(int[] numbers)
      {
        ...
      }
    }
    class Derived : Base
    {
      public override void Method(int[] numbers)
      {
        ...
      }
    }

