
Delegate event handlers (i.e. delegates used as type of an event) should have a very specific signature:

- Return type `void`.
- First argument of type `System.Object` and named 'sender'.
- Second argument of type `System.EventArgs` (or any derived type) and is named 'e'.


This rule raises an issue whenever a `delegate` declaration doesn't match that signature.

## Noncompliant Code Example


    public delegate void AlarmEventHandler(object s);
    
    public class Foo
    {
        public event AlarmEventHandler AlarmEvent; // Noncompliant
    }


## Compliant Solution


    public delegate void AlarmEventHandler(object sender, AlarmEventArgs e);
    
    public class Foo
    {
        public event AlarmEventHandler AlarmEvent; // Compliant
    }


## See

[Handling and Raising Events](https://msdn.microsoft.com/en-us/library/edzehd2t.aspx)
