
Having all branches in a `switch` or `if` chain with the same implementation is an error. Either a copy-paste error was made<br>and something different should be executed, or there shouldn't be a `switch`/`if` chain at all.

## Noncompliant Code Example


    if (b == 0)  // Noncompliant
    {
        DoTheThing();
    }
    else
    {
        DoTheThing();
    }
    
    int b = a &gt; 12 ? 4 : 4;  // Noncompliant
    
    switch (i) // Noncompliant
    {
        case 1:
            DoSomething();
            break;
        case 2:
            DoSomething();
            break;
        case 3:
            DoSomething();
            break;
        default:
            DoSomething();
    }


## Exceptions

This rule does not apply to `if` chains without `else`-s, or to `switch`-es without `default`<br>clauses.


    if (b == 0)    //no issue, this could have been done on purpose to make the code more readable
    {
        DoSomething();
    }
    else if (b == 1)
    {
        DoSomething();
    }

