
Properties and Get method should have names that makes them clearly distinguishable.

This rule raises an issue when the name of a public or protected member starts with 'Get' and otherwise matches the name of a public or protected<br>property.

## Noncompliant Code Example


    using System;
    
    namespace MyLibrary
    {
        public class Foo
        {
            public DateTime Date
            {
                get { return DateTime.Today; }
            }
    
            public string GetDate() // Noncompliant
            {
                return this.Date.ToString();
            }
        }
    }


## Compliant Solution


    using System;
    
    namespace MyLibrary
    {
        public class Foo
        {
            public DateTime Date
            {
                get { return DateTime.Today; }
            }
    
            public string GetDateAsString()
            {
                return this.Date.ToString();
            }
        }
    }

