
In the Attributed Programming Model, the `ExportAttribute` declares that a part "exports", or provides to the composition container, an<br>object that fulfills a particular contract. During composition, parts with imports that have matching contracts will have those dependencies filled by<br>the exported object.

If the type doesn't implement the interface it is exporting there will be an issue at runtime (either a cast exception or just a container not<br>filled with the exported type) leading to unexpected behaviors/crashes.

The rule raises an issue when a class doesn't implement or inherit the type declared in the `ExportAttribute`.

## Noncompliant Code Example


    [Export(typeof(ISomeType))]
    public class SomeType // Noncompliant; doesn't implement 'ISomeType'.
    {
    }


## Compliant Solution


    [Export(typeof(ISomeType))]
    public class SomeType : ISomeType
    {
    }

