
An un-authenticated LDAP connection can lead to transactions without access control. Authentication, and with it, access control, are the last line<br>of defense against LDAP injections and should not be disabled.

This rule raises an issue when an LDAP connection is created with `AuthenticationTypes.Anonymous` or<br>`AuthenticationTypes.None`.

## Noncompliant Code Example


    DirectoryEntry myDirectoryEntry = new DirectoryEntry(adPath);
    myDirectoryEntry.AuthenticationType = AuthenticationTypes.None; // Noncompliant
    
    DirectoryEntry myDirectoryEntry = new DirectoryEntry(adPath, "u", "p", AuthenticationTypes.None); // Noncompliant


## Compliant Solution


    DirectoryEntry myDirectoryEntry = new DirectoryEntry(myADSPath); // Compliant; default DirectoryEntry.AuthenticationType property value is "Secure" since .NET Framework 2.0
    
    DirectoryEntry myDirectoryEntry = new DirectoryEntry(myADSPath, "u", "p", AuthenticationTypes.Secure);


## See

- [OWASP Top 10 2017 Category A2](https://www.owasp.org/index.php/Top_10-2017_A2-Broken_Authentication) - Broken Authentication
- [CWE-521](https://cwe.mitre.org/data/definitions/521.html) - Weak Password Requirements
- [Modes of Authenticating to LDAP](https://docs.oracle.com/javase/tutorial/jndi/ldap/authentication.html)
- Derived from FindSecBugs rule [LDAP\_ANONYMOUS](https://find-sec-bugs.github.io/bugs.htm#LDAP_ANONYMOUS)

