
Hashing data is security-sensitive. It has led in the past to the following vulnerabilities:

- [CVE-2018-9233](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2018-9233)
- [CVE-2013-5097](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2013-5097)
- [CVE-2007-1051](http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1051)


Cryptographic hash functions are used to uniquely identify information without storing their original form. When not done properly, an attacker can<br>steal the original information by guessing it (ex: with a [rainbow table](https://en.wikipedia.org/wiki/Rainbow_table)), or replace the<br>original data with another one having the same hash.

This rule flags code that initiates hashing.

## Ask Yourself Whether

- the hashed value is used in a security context.
- the hashing algorithm you are using is known to have vulnerabilities.
- [salts](https://en.wikipedia.org/wiki/Salt_%28cryptography%29) are not automatically generated and applied by the hashing function.<br>
- any generated salts are cryptographically weak or not credential-specific.


You are at risk if you answered yes to the first question and any of the following ones.

## Recommended Secure Coding Practices

- for security related purposes, use only hashing algorithms which are [currently known to be strong](https://www.owasp.org/index.php/Password_Storage_Cheat_Sheet). Avoid using algorithms like MD5 and SHA1<br>  completely in security contexts.
- do not define your own hashing- or salt algorithms as they will most probably have flaws.
- do not use algorithms that compute too quickly, like SHA256, as it must remain beyond modern hardware capabilities to perform brute force and<br>  dictionary based attacks.
- use a hashing algorithm that generate its own salts as part of the hashing. If you generate your own salts, make sure that a cryptographically<br>  strong salt algorithm is used, that generated salts are credential-specific, and finally, that the salt is applied correctly before the hashing.<br>
- save both the salt and the hashed value in the relevant database record; during future validation operations, the salt and hash can then be<br>  retrieved from the database. The hash is recalculated with the stored salt and the value being validated, and the result compared to the stored<br>  hash.
- the strength of hashing algorithms often decreases over time as hardware capabilities increase. Check regularly that the algorithms you are<br>  using are still considered secure. If needed, rehash your data using a stronger algorithm.


## Sensitive Code Example


    using System.Security.Cryptography;
    
    void ComputeHash()
    {
        // Review all instantiations of classes that inherit from HashAlgorithm, for example:
        HashAlgorithm hashAlgo = HashAlgorithm.Create(); // Sensitive
        HashAlgorithm hashAlgo2 = HashAlgorithm.Create("SHA1"); // Sensitive
        SHA1 sha = new SHA1CryptoServiceProvider(); // Sensitive
        MD5 md5 = new MD5CryptoServiceProvider(); // Sensitive
        // ...
    }
    
    class MyHashAlgorithm : HashAlgorithm // Sensitive
    {
        // ...
    }


## See

- [OWASP Top 10 2017 Category A3](https://www.owasp.org/index.php/Top_10-2017_A3-Sensitive_Data_Exposure) - Sensitive Data Exposure<br>
- [OWASP Top 10 2017 Category A6](https://www.owasp.org/index.php/Top_10-2017_A6-Security_Misconfiguration) - Security<br>  Misconfiguration
- [MITRE, CWE-916](https://cwe.mitre.org/data/definitions/916.html) - Use of Password Hash With Insufficient Computational Effort<br>
- [MITRE, CWE-759](http://cwe.mitre.org/data/definitions/759.html) - Use of a One-Way Hash without a Salt
- [MITRE, CWE-760](http://cwe.mitre.org/data/definitions/760.html) - Use of a One-Way Hash with a Predictable Salt
- [SANS Top 25](https://www.sans.org/top25-software-errors/#cat3) - Porous Defenses

