# [Persistent Cookie Usage](http://find-sec-bugs.github.io/bugs.htm#COOKIE_PERSISTENT)

Storing sensitive data in a persistent cookie for an extended period can lead to a breach of confidentiality or account compromise.

    **Explanation:**  

If private information is stored in persistent cookies, attackers have a larger time window in which to steal this data - especially since persistent cookies are often set to expire in the distant future. Persistent cookies are generally stored in a text file on the client and an attacker with access to the victim's machine can steal this information.  

Persistent cookies are often used to profile users as they interact with a site. Depending on what is done with this tracking data, it is possible to use persistent cookies to violate users' privacy.

    **Vulnerable Code:** The following code sets a cookie to expire in 1 year.  

<pre>[...]
Cookie cookie = new Cookie("email", email);
cookie.setMaxAge(60*60*24*365);
[...]</pre>

    **Solution:**  

*   Use persistent cookies only if necessary and limit their maximum age.
*   Don't use persistent cookies for sensitive data.

**References**  

[Class Cookie `setMaxAge` documentation](https://tomcat.apache.org/tomcat-5.5-doc/servletapi/javax/servlet/http/Cookie.html#setMaxAge%28int%29)  

[CWE-539: Information Exposure Through Persistent Cookies](https://cwe.mitre.org/data/definitions/539.html)