---
pageClass: rule-details
sidebarDepth: 0
title: vue/brace-style
description: enforce consistent brace style for blocks
---
# vue/brace-style
> enforce consistent brace style for blocks

- :wrench: The `--fix` option on the [command line](https://eslint.org/docs/user-guide/command-line-interface#fixing-problems) can automatically fix some of the problems reported by this rule.

This rule is the same rule as core [brace-style] rule but it applies to the expressions in `<template>`.

## :books: Further reading

- [brace-style]

[brace-style]: https://eslint.org/docs/rules/brace-style

## :mag: Implementation

- [Rule source](https://github.com/vuejs/eslint-plugin-vue/blob/master/lib/rules/brace-style.js)
- [Test source](https://github.com/vuejs/eslint-plugin-vue/blob/master/tests/lib/rules/brace-style.js)
