## Do not use apt-get upgrade or dist-upgrade.

### Problematic code:

```dockerfile
FROM debian
RUN apt-get update && apt-get upgrade 
```

### Correct code:

```dockerfile
FROM debian
RUN apt-get update
```
### Rationale:

http://crosbymichael.com/dockerfile-best-practices-take-2.html

> Updates will be baked into the based images you don't need to apt-get upgrade your containers. Because of the isolation that happens this can often fail if something is trying to modify init or make device changes inside a container. It also produces inconsistent images because you no longer have one source of truth of how your application should run and what versions of dependencies are included in the image.

https://docs.docker.com/engine/articles/dockerfile_best-practices/

> You should avoid RUN apt-get upgrade or dist-upgrade, as many of the “essential” packages from the base images won’t upgrade inside an unprivileged container. If a package contained in the base image is out-of-date, you should contact its maintainers.