# $ is not used specially and should therefore be escaped.

### Problematic code:

```sh
echo "$"
```

### Correct code:

```sh
echo "\$"
```

### Rationale:
`$` is special in double quotes, but there are some cases where it's interpreted literally:

1. Following a backslash: `echo "\$"`
2. In a context where the shell can't make sense of it, such as at the end of the string, (`"foo$"`) or before some constructs (`"$'foo'"`).

To avoid relying on strange and shell-specific behavior, any `$` intended to be literal should be escaped with a backslash.
