## Use semicolon or linefeed before 'done' (or quote to make it literal).

### Problematic code:

```
for f in *; do echo "$f" done
```
or

```
echo $f is done
```

### Correct code:

```
for f in *; do echo "$f"; done
```

or

```
echo "$f is done"
```


### Rationale:

`done` only works as a keyword when it's the first token of the command. If added after a command, it will just be the literal word "done". 

This is also true for other keywords like `then`.

### Exceptions

If you're intentionally using `done` as a literal, you can quote it to make this clear to shellcheck (and also human readers), e.g. instead of `echo Task is done`, use `echo "Task is done"`. This makes no difference to the shell, but it will silence this warning.
