## Unexpected ==. For assignment, use =. For comparison, use [/[[.

### Problematic code:

```sh
var==value
```

### Correct code:

Assignment:

```sh
var=value
```

Comparison:

```sh
[ "$var" = value ]
```

### Rationale:

ShellCheck has noticed that you're using `==` in an unexpected way. The two most common reasons for this is:

* You wanted to assign a value but accidentally used `==` instead of `=`.

* You wanted to compare two values, but neglected to use `[ .. ]` or `[[ .. ]]`.

### Exceptions:

If you wanted to assign a literal equals sign, use quotes to make this clear:

```sh
var="=sum(A1:A10)"
```
