
This cop checks for the use of `Kernel#open`.

`Kernel#open` enables not only file access but also process invocation
by prefixing a pipe symbol (e.g., `open("| ls")`). So, it may lead to
a serious security risk by using variable input to the argument of
`Kernel#open`. It would be better to use `File.open`, `IO.popen` or
`URI#open` explicitly.

# Examples

```ruby
# bad
open(something)

# good
File.open(something)
IO.popen(something)
URI.parse(something).open
```

[Source](http://www.rubydoc.info/gems/rubocop/RuboCop/Cop/Security/Open)