The use of a predictable random value can lead to vulnerabilities when used in certain security critical contexts. For example, when the value is used as:

*  a CSRF token
*  a password reset token (sent by email)
*  any other secret value
*  A quick fix could be to replace the use of java.util.Random with something stronger, such as java.security.SecureRandom.

Vulnerable Code:

````
String generateSecretToken() {
    Random r = new Random();
    return Long.toHexString(r.nextLong());
}

````

Solution:

````

import org.apache.commons.codec.binary.Hex;

String generateSecretToken() {
    SecureRandom secRandom = new SecureRandom();

    byte[] result = new byte[32];
    secRandom.nextBytes(result);
    return Hex.encodeHexString(result);
}

````

[More Information](http://h3xstream.github.io/find-sec-bugs/bugs.htm#PREDICTABLE_RANDOM)