## You need a space here

### Problematic code:

```sh
if ![-z foo ]; then true; fi # if command `[-z' w/ args `foo', `]' fails..
```
### Correct code:

```sh
if ! [ -z foo ]; then true; fi # if command `[' w/ args `-z', `foo', `]' fails..
```

### Rationale:

Bourne shells are very whitespace sensitive. Adding or removing spaces can drastically alter the meaning of a script. In these cases, ShellCheck has noticed that you're missing a space at the position indicated.

### Exceptions

ShellCheck does not understand [Bash History Expansion](https://www.gnu.org/software/bash/manual/html_node/History-Interaction.html), an interactive shell feature also using `!` (such as `!!` to expand to the previous command). 

These features are disabled by default in shells and very rarely used in scripts, but may occasionally be found in interactively sourced files like `.bashrc`. Please ignore the error in these cases.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1035)

