## Found 'eof' further down, but not on a separate line.

    Close matches include '-eof' (!= 'eof').

### Problematic code:

```sh
cat <<-eof
Hello World
-eof
```

### Correct code:

```sh
cat <<- eof
Hello World
eof
```
### Rationale:

Your here document isn't properly terminated.

There is a line containing the terminator you've chosen, but it's not by itself on a separate line.

In the example code, the script uses `<<-eof`, which is the operator `<<-` followed by `eof`. The script therefore looks for `eof` and skips right past the intended terminator because it starts with a dash.

You will get some companion SC1042 errors mentioning lines that contain the string as a substring, though they all point to the start of the here document and not the relevant line:

```
In foo line 4:
Hello
^-- SC1041: Found 'eof' further down, but not on a separate line.
^-- SC1042: Close matches include '-eof' (!= 'eof').
```

Look at your here document and see which line was supposed to terminate it. Then ensure it matches the token exactly, and that it's on its own line with no text before or after.

Under Windows the error might occur due to the standard CRLF line-ending, which is Windows-specific.
Try to change the line ending into LF.

### Exceptions:

None.

---
Note that SC1041 and SC1042 swapped numbers after v0.4.6 to improve the display order. This rare instance of number reuse was justified by them always occuring together on the same line.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1041)

