## Can't have empty then clauses (use 'true' as a no-op).

### Problematic code:

```sh
if [ -e foo ]
then
  # TODO: handle this
fi
```
### Correct code:
```sh
if [ -e foo ]
then
  # TODO: handle this
  true
fi

# Or use the no-op colon operator ":"
if [ -e foo ]
then
  # TODO: handle this
  :
fi
```

### Rationale:

Shells do not allow empty `then` clauses. They need at least one command (and comments are not commands).

If you want a `then` clause that does nothing, use a dummy command like `true`.

### Exceptions:

None.
[Source](https://github.com/koalaman/shellcheck/wiki/SC1048)

