## Don't use $ on the iterator name in for loops.

### Problematic code:

```sh
for $var in *
do
  echo "$var"
done
```

### Correct code:

```sh
for var in *
do
  echo "$var"
done
```

### Rationale:

The variable is named `var`, and can be expanded to its value with `$var`.

The `for` loop expects the variable's name, not its value (and the name can not be specified indirectly).

### Exceptions

None.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1086)

