## Parsing of sourced file failed. Ignoring it.

### Problematic code:

```sh
source mylib
```

### Correct code:

```sh
# shellcheck disable=SC1094
source mylib
```

(or fix `mylib`)

### Rationale:

ShellCheck encountered a parsing error in a sourced file, `mylib` in the example.

Fix parsing error, or just disable it with a directive.

### Exceptions:

If the file is fine and this is due to a known `shellcheck` bug, you can ignore it with a [[directive]] as in the example.

[Source](https://github.com/koalaman/shellcheck/wiki/SC1094)

